package Functions;

sub GetDate{
my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
my($y_f,$mon_f,$mday_f,$date,$date_d,$time_d);

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
$mon++;
$min=sprintf("%02d",$min);
$year=$year+1900;
$mon=sprintf("%02d",$mon);
$mday=sprintf("%02d",$mday);
$y_f=substr($year,2,2);
$mon_f=sprintf("%02d",$mon);
$mday_f=sprintf("%02d",$mday);

@waweek=('日','月','火','水','木','金','土');
$date="$year年$mon月$mday日($waweek[$wday]) $hour時$min分";
$date_d="$year/$mon/$mday";
$time_d="$hour:$min";

return ($date,$date_d,$time_d);

}

sub GetId{
my(@saltset,$key,$i);

if($CF::id == 2){
	@saltset=('a'..'z','A'..'Z','0'..'9');
}
elsif($CF::id == 1){
	@saltset=('a'..'z','A'..'Z');
}
else{
	@saltset=('0'..'9');
}

srand(time^$$);
$key="";
for($i=0;$i<12;$i++){
	$key.=$saltset[int(rand(@saltset))];
}
return $key;

}


sub GetCookie{
my($name,$value,$pair,@pairs,$cookies,%cookie);
$cookies=$ENV{'HTTP_COOKIE'};
@pairs=split(/;/,$cookies);
foreach $pair(@pairs){
	($name,$value)=split(/=/,$pair);
	$name=~s/ //g;
	$cookie{$name}=$value;
}
return %cookie;

}

sub SetCookie{
my($cook,$name,$path,$enc,$time,$cpath,$ctime);
my($secg,$ming,$hourg,$mdayg,$mong,$yearg,$wdayg,$ydayg,$isdstg);
my(@month,@week,$date_gmt,$hozon);

$cook=$_[0];
$name=$_[1];
$path=$_[2];
$enc=$_[3];
$time=$_[4];
$hozon=$_[5];

if($enc){
	$cook=&urlencode($cook);
}

if($path eq "root"){
	$cpath=' path=/;';
}
else{
	$cpath="";
}

if($time){
	($secg,$ming,$hourg,$mdayg,$mong,$yearg,$wdayg,$ydayg,$isdstg)=gmtime(time+$hozon*24*60*60);
	@month=('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	@week=('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	$date_gmt=sprintf("%s, %02d\-%s\-%04d %02d:%02d:%02d GMT",$week[$wdayg],$mdayg,$month[$mong],$yearg+1900,$hourg,$ming,$secg);
	$ctime=" expires=$date_gmt";
}
else{
	$ctime="";
}

print "Set-Cookie: ${name}=${cook};${cpath}${ctime}\n";
}


sub CookieDel{
my($name,$pass);
$name=$_[0];
$pass=$_[1];

if($path eq "root"){
	$cpath=' path=/;';
}
else{
	$cpath="";
}

print "Set-Cookie: $name=;${cpath}\n";
}

sub CookieDel2{
my($name);
$name=$_[0];
print "Set-Cookie: $name=; path=/\n";
}

sub urlencode{
my($str);
$str=$_[0];
$str=~s/([^\w ])/'%'.unpack("H2",$1)/eg;
$str=~tr/ /+/;
return $str;
}


sub GetSessId{
return $main::COOKIE{$CF::c_name};
}

sub SplitCart{
my($ln,%t,@values);
$ln=$_[0];

@values=split(/,/,$ln);

@t{@CF::keys_cart} = @values;

return \%t;
}

sub MakeLine{
my(@tmp,$l,$ref,$fo_ref);
$ref=$_[0];
$fo_ref=$_[1];

@tmp=();
foreach $l(@{$ref}){
	push(@tmp,${$fo_ref}{$l});
}
$line=join(",",@tmp);

return $line;
}




sub OpenData{
my($sessid,$file,$idx,@all);
$sessid=$_[0];

$file=$CF::tmpdir.$sessid;
@all=();
if(!$sessid){
	return \@all;
}

if(!-e $file){
	unless(open(TMP,">$file")){
		&main::msgerror("er:ファイルが作成できません。");
	}
	close TMP;
}

unless(open(TMP,$file)){
	&main::msgerror("er:fileが開けません。");
}
$idx=0;
while(<TMP>){
	s/(\r\n|\n)$//;
	$all[$idx++]=$_;
}
close TMP;
return \@all;
}


sub WriteData{
my($sessid,$cook,$file);
$sessid=$_[0];
$cook=$_[1];

$file=$CF::tmpdir.$sessid;

unless(open(TMP,">$file")){
	&main::msgerror("er:tmplogに書き込めません。パーミッション等を確認してください。");
}
print TMP $cook;
close TMP;

}

sub MakeSess{
my(@saltset,$key,$i);
@saltset=('a'..'z','A'..'Z','0'..'9');
srand(time^$$);
$key="";
for($i=0;$i<32;$i++){
	$key.=$saltset[int(rand(@saltset))];
}
return $key;
}


sub PostageCal{
my($total,$subtotal,$postage_all,$a_total,$co,$cl_charge);

$total=$_[0];
$subtotal=$_[1];
$postage_all=$_[2];
$a_total=$_[3];

$a_total-=$no_s_count;
if($CF::postage==0){
	$postage_all=0;
}
elsif($CF::postage==1){
	$postage_all=$CF::postage_fix;
	if($a_total == 0){
		$postage_all=0;
	}
}
elsif($CF::postage==2){
	$postage_all=$CF::postage_each*$a_total;
}
if($CF::postage_off){
	if($subtotal >= $CF::postage_line){
		$postage_all=0;
	}
}

$total+=$postage_all;

return($total,$postage_all);
}

sub PostageCal2{
my($total,$subtotal,$weight_all,$vol_all,$deli,$ar,$co,$a_total,$p,$postage_all);

$total=$_[0];
$subtotal=$_[1];
$weight_all=$_[2];
$vol_all=$_[3];
$deli=$_[4];
$ar=$_[5];
$a_total=$_[6];

$postage_all=0;


if($deli eq 'ゆうパック'){
	unless(-e './lib/deliver/yupack.pl'){
		&main::error("yupack.plがありません。");
	}
	require './lib/deliver/yupack.pl';
	$p=&Cal("yu",$weight_all,$vol_all,$ar,$a_total);

}
elsif($deli eq '佐川急便'){
	unless(-e './lib/deliver/sagawa.pl'){
		&main::error("sagawa.plがありません。");
	}
	require './lib/deliver/sagawa.pl';
	$p=&Cal("sa",$weight_all,$vol_all,$ar,$a_total);
}
elsif($deli eq 'クロネコヤマト'){
	unless(-e './lib/deliver/kuroneko.pl'){
		&main::error("kuroneko.plがありません。");
	}
	require './lib/deliver/kuroneko.pl';
	$p=&Cal("kuro",$weight_all,$vol_all,$ar,$a_total);
}
elsif($deli eq '定形外郵便'){
	unless(-e './lib/deliver/teikeigai.pl'){
		&main::error("teikeigai.plがありません。");
	}
	require './lib/deliver/teikeigai.pl';
	$p=&Cal_tei($weight_all);
}
elsif($deli eq 'メール便'){
	unless(-e './lib/deliver/mailbin.pl'){
		&main::error("mailbin.plがありません。");
	}
	require './lib/deliver/mailbin.pl';
	$p=&Cal_tei($weight_all);
}

if($p){
	$postage_all=$p;
}

if($CF::postage_off && $subtotal >= $CF::postage_line){
	$postage_all=0;
}
$total+=$postage_all;

return($total,$postage_all);

}


sub Cal{
my($mo,$weight,$vol,$area,$co,$a_total,$ryoukin,$ryoukin_w,$ryoukin_v);

$mo=$_[0];
$weight=$_[1];
$vol=$_[2];
$area=$_[3];
$a_total=$_[4];

$ryoukin=0;
$ryoukin_w=0;
$ryoukin_v=0;

$chiiki="";

if($area eq ""){
	return 0;
}


$flag=0;
foreach $l(@Deliver::areas){
	foreach $v(@{$Deliver::AREA{$l}}){
		if($v eq $area){
			$chiiki=$l;
			$flag=1;
			last;
		}
	}
	if($flag){
		last;
	}
}

if($chiiki eq ""){
	return 0;
}

if($weight){
	$i=0;
	foreach(@Deliver::jyuryo){
		if($_ >= $weight){
			last;
		}
		$i++;
	}
	if($i > $#Deliver::jyuryo){
		$i=$#Deliver::jyuryo;
	}
	$ryoukin_w=${$Deliver::JYU{$chiiki}}[$i];
}
elsif($vol){
	@PA=split(/#/,$vol);
	foreach $p(@PA){
	     ($pack,$a)=split(/:/,$p);
	     $i=0;
	     foreach $v(@Deliver::packsize){
	          if($v >= $pack){
	               $flag=1;
	               last;
	          }
	          $i++;
	     }
	     if($i > $#Deliver::packsize){
	          $i=$#Deliver::packsize;
	     }
	     $ryoukin_v+=${$Deliver::JYU{$chiiki}}[$i] * $a;
	}
}
else{
	$i=0;
	$ryoukin_w=${$Deliver::JYU{$chiiki}}[$i];
}

$ryoukin=$ryoukin_w + $ryoukin_v;


if(!$ryoukin){
	$ryoukin=0;
}


return $ryoukin;

}

sub Cal_tei{
my($weight,$flag,$i,$ryoukin);
$weight=$_[0];

$flag=0;
$i=0;
$ryoukin="";

if($weight){
	foreach(@Deliver::JYURYO){
		if($weight < $_ || $weight == $_){
			last;
		}
		$i++;
	}
}
else{
	$i=0;
}

$ryoukin=$Deliver::JYU[$i];
return $ryoukin;
}


sub Comma{
my($d,$len,$wari,$amari,$i,$act);
$act=$_[0];
$d=$_[1];
$len=length($d);
if($len <= 3){
	if(!$CF::yen){
		$d.='円';
	}
	else{
		if($act eq "order"){
			$d="\\".$d;
		}
		else{
			$d='&yen;'.$d;
		}
	}
	return $d;
}

$wari=int($len / 3);
$amari=$len % 3;
if($amari == 0){
	$wari--;
}

for($i=0;$i<$wari;$i++){
	$d=~s/(\d*\d)(\d{3})/$1,$2/;
}

if(!$CF::yen){
	$d.='円';
}
else{
	if($act eq "order"){
		$d="\\".$d;
	}
	else{
		$d='&yen;'.$d;
	}
}

return $d;
}


sub Kazei{
my($price,$tax_each,$ritu);
$price=$_[0];
$ritu=$_[1];
if(!$ritu){
	$ritu=$CF::taxrate;
}
if($CF::zei){
	$tax_each=int($price*$ritu/(100+$ritu));
}
else{
	$tax_each=$price*($ritu/100);
}

return $tax_each;
}


sub Wrap{
my($total,$subtotal);
$total=$_[0];
$subtotal=$_[1];
if($CF::wrap_off && $subtotal>=$CF::wrap_off_line){
	$CF::wrap_charge=0;
}
$total+=$CF::wrap_charge;
return($CF::wrap_charge,$total);

}

sub Dai{
my($pay,$total,$subtotal,$i,$daiflag,$dai_charge,$kubun,$ryoukin,@ku,$k,$dainame);

$pay=$_[0];
$total=$_[1];
$subtotal=$_[2];
$i=0;
$daiflag=0;

@keys=keys %CF::dai_count;

foreach(@keys){
	if($pay eq $_){
		$daiflag=1;
		last;
	}
}

if($daiflag){
	$dai_charge=$CF::dai_count{$pay};
	if($dai_charge=~/%/){
		$dai_charge=~s/%//;
		$dai_charge=int($total*($dai_charge/100));

	}
	elsif($dai_charge=~/:/){
		($kubun,$ryoukin)=split(/_/,$dai_charge);
		@ryoukin=split(/:/,$ryoukin);
		@ku=split(/:/,$kubun);
		$k=0;
		foreach(@ku){
			if($subtotal < $_){
				last;
			}
			$k++;
		}
		$dai_charge=$ryoukin[$k];
	}
	if($CF::dai_off && $subtotal>=$CF::dai_line){
		$dai_charge=0;
	}
	$total+=$dai_charge;
	$dainame=$pay;
}
else{
	$dai_charge=0;
}


return($dai_charge,$total,$dainame);
}


$lockflag=0;

sub filelock{
my($file);
$file=$_[0];
if(open(LOCK, ">$file")){
	if(flock(LOCK,2)){
		$lockflag=1;
	}
	else{
		$lockflag=2;
		close LOCK;
	}
}
else{
	&main::error("lockファイルがないか、パーミッションが書き込み可になっていません。");
}
if($lockflag == 2){
	&main::error("書き込みできませんでした。もう一度お試しください。");
}

}

sub unlock{
	close LOCK;
}


1;